package furny.swing.admin.statistics;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import furny.util.LoggerUtil;

/**
 * Starter class for the statistics tool.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public final class StatisticsTool {
  /**
   * Instantiation is not necessary.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  private StatisticsTool() {
  }

  /**
   * Main method to start the statistics tool.
   * 
   * @param args
   *          Arguments are not required.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void main(final String[] args) {
    start();
  }

  /**
   * Starts the statistics tool.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void start() {
    LoggerUtil.installLogger();
    SwingUtilities.invokeLater(new Runnable() {
      @Override
      public void run() {
        try {
          UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (final Exception e) {
          e.printStackTrace();
        }

        new StatisticsFrame().setVisible(true);
      }
    });
  }
}
